<xsl:stylesheet version = "1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="../../Gravey/xsl/grvEDO.xsl"/>
<xsl:output method="text"/> 


<xsl:template match="/">
  gEDOServerError.setValue(
	"<xsl:call-template name='escapeSpecialChars'>
		<xsl:with-param name='string' select='/AIM/ServerError/String'/>
    </xsl:call-template>"
  );

  <xsl:for-each select="/AIM/Auctions">
  gAuctionData.BeginTransaction();
  gAuctionData.reset();

  var tempList = null;
  var aLot    = null;

    <xsl:for-each select="List/Auction">
	gAuctionData._setAuction( new Auction( [
			"<xsl:value-of select='@auctionID'/>",
			"<xsl:value-of select='CreateDate/Date'/>",
			"<xsl:value-of select='LaunchDate/Date'/>",
			"<xsl:value-of select='LockdownDate/Date'/>",
			"<xsl:value-of select='CutoffDate/Date'/>",
			"<xsl:value-of select='AwardDate/Date'/>",
			"<xsl:value-of select='CloseDate/Date'/>"
			],
			"",
			"",
			"<xsl:value-of select='@key'/>",
			gAuctionData,
			"<xsl:value-of select='@itemCount'/>" ) );

    tempList = gAuctionData._newLots();
    tempList.BeginTransaction();
	<xsl:for-each select="Lots/List/Lot">
		aLot = new Lot( [
			"<xsl:value-of select='@lotNumber'/>",
		"<xsl:call-template name='escapeSpecialChars'>
			<xsl:with-param name='string' select='@lotName'/>
		</xsl:call-template>",
			"<xsl:value-of select='EffectivePayDate/Date'/>",
			"<xsl:value-of select='CloseDate/Date'/>",
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='AmountExpPerItem/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentActualBid/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentCommission/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentEstTargetPct/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='@contactKey'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='@shippingKey'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='@bidderKey'/>
		</xsl:call-template>
			],
			"",
			"",
			"<xsl:value-of select='@key'/>",
			gAuctionData,
			"<xsl:value-of select='@itemCount'/>" );

		aLot.contName =
		"<xsl:call-template name='escapeSpecialChars'>
			<xsl:with-param name='string' select='@contName'/>
		</xsl:call-template>";

		aLot.shipName = 
		"<xsl:call-template name='escapeSpecialChars'>
			<xsl:with-param name='string' select='@shipName'/>
		</xsl:call-template>";
     
		tempList.addItem( aLot );
	</xsl:for-each>
	tempList.EndTransaction(true);
    </xsl:for-each>

  gAuctionData.EndTransaction(true);
  </xsl:for-each>
  grvUNWAIT();
</xsl:template>

</xsl:stylesheet>