<xsl:stylesheet version = "1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="../../Gravey/xsl/grvEDO.xsl"/>
<xsl:output method="text"/> 


<xsl:template match="/">
  gEDOServerError.setValue(
	"<xsl:call-template name='escapeSpecialChars'>
		<xsl:with-param name='string' select='/AIM/ServerError/String'/>
    </xsl:call-template>"
  );

  <xsl:for-each select="/AIM/Bidders/List/Bidder">
 {
  var tempList = null;
  var bidderKey = <xsl:value-of select='@key'/>;
 
	tempList = _ContactsSelected( bidderKey );
	tempList.loaded = true;
	tempList = tempList.model;
    tempList.BeginTransaction();
    tempList.reset();
	tempList.addItem( 0, new MVCDecode( "Contact", "0", "", 1 ) );
	<xsl:for-each select="Contacts/List/Contact">
		tempList.addItem( "<xsl:value-of select='@key'/>",
			new MVCDecode( "Contact",
			"<xsl:value-of select='@key'/>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@contactName'/>
			</xsl:call-template>",
			<xsl:call-template name='genVal'>
				<xsl:with-param name='theVar' select='@lotCount'/>
			</xsl:call-template>
		 ) );
	</xsl:for-each>
	tempList.EndTransaction();

	tempList = _ShippingSelected( bidderKey );
	tempList.loaded = true;
	tempList = tempList.model;
    tempList.BeginTransaction();
    tempList.reset();
	tempList.addItem( 0, new MVCDecode( "Shipping", "0", "", 1 ) );
	<xsl:for-each select="Shippings/List/Shipping">
		tempList.addItem( "<xsl:value-of select='@key'/>",
			new MVCDecode( "Shipping",
			"<xsl:value-of select='@key'/>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@companyName'/>
			</xsl:call-template>",
			<xsl:call-template name='genVal'>
				<xsl:with-param name='theVar' select='@lotCount'/>
			</xsl:call-template>
		 ) );
	</xsl:for-each>
	tempList.EndTransaction();
  }
  </xsl:for-each>

  _gGrvHackStartupInhibitWait = false;
//grvUNWAIT();
</xsl:template>

</xsl:stylesheet>