<xsl:stylesheet version = "1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="../../Gravey/xsl/grvEDO.xsl"/>
<xsl:output method="text"/> 


<xsl:template match="/">
  gEDOServerError.setValue(
	"<xsl:call-template name='escapeSpecialChars'>
		<xsl:with-param name='string' select='/AIM/ServerError/String'/>
    </xsl:call-template>"
  );

  <xsl:for-each select="/AIM/Bidders">
  gBidderData.BeginTransaction();
  gBidderData.reset();

  var tempList = null;

    <xsl:for-each select="List/Bidder">
	gBidderData._setBidder( new Bidder( [
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@companyName'/>
		    </xsl:call-template>",
		"<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='@ficoCode'/>
		</xsl:call-template>",
		 	<xsl:value-of select='@inactive'/>
			],
			"",
			"",
			"<xsl:value-of select='@key'/>",
			gBidderData,
			"<xsl:value-of select='@lotCount'/>" ) );

    tempList = gBidderData._newContacts();
    tempList.BeginTransaction();
	<xsl:for-each select="Contacts/List/Contact">
		tempList.addItem( new Contact( [
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@contactName'/>
		    </xsl:call-template>",
			"<xsl:value-of select='@phoneNum'/>",
			"<xsl:value-of select='@faxNum'/>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@streetAddr'/>
		    </xsl:call-template>",
			"<xsl:value-of select='@cityName'/>",
			"<xsl:value-of select='@stateCode'/>",
			"<xsl:value-of select='@zipCode'/>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@emailAddr'/>
		    </xsl:call-template>",
		    "<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@wiringInstructions'/>
		    </xsl:call-template>"
			],
			"",
			"",
			"<xsl:value-of select='@key'/>",
			gBidderData,
			"<xsl:value-of select='@lotCount'/>" ) );
	</xsl:for-each>
	tempList.EndTransaction(true);

    tempList = gBidderData._newShipping();
    tempList.BeginTransaction();
	<xsl:for-each select="Shippings/List/Shipping">
		tempList.addItem( new Shipping( [
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@contactName'/>
		    </xsl:call-template>",
			"<xsl:value-of select='@phoneNum'/>",
			"<xsl:value-of select='@faxNum'/>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@streetAddr'/>
		    </xsl:call-template>",
			"<xsl:value-of select='@cityName'/>",
			"<xsl:value-of select='@stateCode'/>",
			"<xsl:value-of select='@zipCode'/>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@emailAddr'/>
		    </xsl:call-template>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@companyName'/>
		    </xsl:call-template>"
			],
			"",
			"",
			"<xsl:value-of select='@key'/>",
			gBidderData,
			"<xsl:value-of select='@lotCount'/>" ) );
	</xsl:for-each>
	tempList.EndTransaction(true);
    </xsl:for-each>

  gBidderData.EndTransaction(true);
  </xsl:for-each>
  grvUNWAIT();
</xsl:template>

</xsl:stylesheet>