<xsl:stylesheet version = "1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="../../Gravey/xsl/grvEDO.xsl"/>
<xsl:output method="text"/> 


<xsl:template match="/">
  gEDOServerError.setValue(
	"<xsl:call-template name='escapeSpecialChars'>
		<xsl:with-param name='string' select='/AIM/ServerError/String'/>
    </xsl:call-template>"
  );

  <xsl:for-each select="/AIM/Items">
  gItemData.BeginTransaction();
  gItemData.reset();

    <xsl:for-each select="List/PlainItem">
	gItemData._setItem( new Item( [

			"<xsl:value-of select='@lotKey'/>",
			"<xsl:value-of select='@lotNumber'/>",
		 	<xsl:value-of select='@pulled'/>,
		 	<xsl:value-of select='@eligibleVIP'/>,

			"<xsl:value-of select='@itemTypeCode'/>",
			"<xsl:value-of select='LastUpdatedDate/Date'/>",
			"<xsl:value-of select='FirstAddedDate/Date'/>",

			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@itemName'/>
		    </xsl:call-template>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@streetAddr'/>
		    </xsl:call-template>",
			"<xsl:value-of select='@cityName'/>",
			"<xsl:value-of select='@stateCode'/>",
			"<xsl:value-of select='@zipCode'/>",

		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='AmountBook/BigDecimal'/>
		</xsl:call-template>,

		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentTarget/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentReserve/BigDecimal'/>
		</xsl:call-template>,

		 	"<xsl:value-of select='@numberItem'/>",

			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@comments'/>
		    </xsl:call-template>",
		    "<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@ownerName'/>
		    </xsl:call-template>"
			],

			"",	"",	"<xsl:value-of select='@key'/>", gItemData ) );
    </xsl:for-each>


    <xsl:for-each select="List/Loan">
	gItemData._setItem( new Item( [

			"<xsl:value-of select='@lotKey'/>",
			"<xsl:value-of select='@lotNumber'/>",
		 	<xsl:value-of select='@pulled'/>,
		 	<xsl:value-of select='@eligibleVIP'/>,

			"<xsl:value-of select='@itemTypeCode'/>",
			"<xsl:value-of select='LastUpdatedDate/Date'/>",
			"<xsl:value-of select='FirstAddedDate/Date'/>",

			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@itemName'/>
		    </xsl:call-template>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@streetAddr'/>
		    </xsl:call-template>",
			"<xsl:value-of select='@cityName'/>",
			"<xsl:value-of select='@stateCode'/>",
			"<xsl:value-of select='@zipCode'/>",

		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='AmountBook/BigDecimal'/>
		</xsl:call-template>,

		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentTarget/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentReserve/BigDecimal'/>
		</xsl:call-template>,

		 	"<xsl:value-of select='@numberItem'/>",

			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@comments'/>
		    </xsl:call-template>",
		    "<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@ownerName'/>
		    </xsl:call-template>"
			],

			"", "", "<xsl:value-of select='@key'/>", gItemData ) );

	gItemData._setLoan( new Loan( [

			"<xsl:value-of select='@bankNo'/>",
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='InterestRate/BigDecimal'/>
		</xsl:call-template>
			],

			"", "", "<xsl:value-of select='@key'/>", gItemData ) );
    </xsl:for-each>

  gItemData.EndTransaction(true);
  </xsl:for-each>

  grvUNWAIT();
</xsl:template>

</xsl:stylesheet>