<xsl:stylesheet version = "1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="../../Gravey/xsl/grvEDO.xsl"/>
<xsl:output method="text"/> 

<xsl:template match="/">
  gAccountData.BeginTransaction();
  gAccountData.reset();
  var tempTransList = null;
  <xsl:for-each select="/RATS/Balances/List/Balance">
    tempTransList = new MVCListModel( "TransactionsListModel" );
    tempTransList.BeginTransaction();
	<xsl:for-each select="Transactions/List/Transaction">
		tempTransList.addItem( new Transaction(
			"<xsl:value-of select='@complexCode'/>",
			"<xsl:value-of select='@transType'/>",
		<xsl:call-template name='genVal'>
			<xsl:with-param name='theVar' select='AmountA/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genVal'>
			<xsl:with-param name='theVar' select='AmountB/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genVal'>
			<xsl:with-param name='theVar' select='AmountC/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genVal'>
			<xsl:with-param name='theVar' select='AmountD/BigDecimal'/>
		</xsl:call-template>,
			"<xsl:value-of select='EditDate/Date'/>",
			"<xsl:value-of select='@editUser'/>",
			"<xsl:value-of select='@key'/>" ) );
	</xsl:for-each>
	tempTransList.EndTransaction(true);
	gAccountData.addItem( new Balance(
			"<xsl:value-of select='BalanceDate/Date'/>",
		<xsl:call-template name='genVal'>
			<xsl:with-param name='theVar' select='AmountA/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genVal'>
			<xsl:with-param name='theVar' select='AmountB/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genVal'>
			<xsl:with-param name='theVar' select='AmountC/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genVal'>
			<xsl:with-param name='theVar' select='AmountD/BigDecimal'/>
		</xsl:call-template>,
			 <xsl:value-of select='@reconciled'/>,
			"<xsl:value-of select='@system'/>", tempTransList ) );
  </xsl:for-each>
	gAccountData.EndTransaction(true);
</xsl:template>

</xsl:stylesheet>