<xsl:stylesheet version = "1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- xsl:import href="../../Gravey/xsl/grvEDO.xsl"/ -->
<!-- =============================================================
     == Because of Safari/Chrome/IE7/8 bugs, xsl:import fails!
     == We will include the guts of this file directly as a hack.
     == See the bottom of this file...
     =============================================================
-->
<xsl:output method="text"/> 


<xsl:template match="/">
  gEDOServerError.setValue(
	"<xsl:call-template name='escapeSpecialChars'>
		<xsl:with-param name='string' select='/AIM/ServerError/String'/>
    </xsl:call-template>"
  );

  <xsl:for-each select="/AIM/Auctions">
  gAuctionData.BeginTransaction();
  gAuctionData.reset();

  var tempList = null;
  var aLot    = null;

    <xsl:for-each select="List/Auction">
	gAuctionData._setAuction( new Auction( [
			"<xsl:value-of select='@auctionID'/>",
			"<xsl:value-of select='CreateDate/Date'/>",
			"<xsl:value-of select='LaunchDate/Date'/>",
			"<xsl:value-of select='LockdownDate/Date'/>",
			"<xsl:value-of select='CutoffDate/Date'/>",
			"<xsl:value-of select='AwardDate/Date'/>",
			"<xsl:value-of select='CloseDate/Date'/>"
			],
			"",
			"",
			"<xsl:value-of select='@key'/>",
			gAuctionData,
			"<xsl:value-of select='@itemCount'/>" ) );

    tempList = gAuctionData._newLots();
    tempList.BeginTransaction();
	<xsl:for-each select="Lots/List/Lot">
		aLot = new Lot( [
			"<xsl:value-of select='@lotNumber'/>",
		"<xsl:call-template name='escapeSpecialChars'>
			<xsl:with-param name='string' select='@lotName'/>
		</xsl:call-template>",
			"<xsl:value-of select='EffectivePayDate/Date'/>",
			"<xsl:value-of select='CloseDate/Date'/>",
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='AmountExpPerItem/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentActualBid/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentCommission/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='PercentEstTargetPct/BigDecimal'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='@contactKey'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='@shippingKey'/>
		</xsl:call-template>,
		<xsl:call-template name='genZero'>
			<xsl:with-param name='theVar' select='@bidderKey'/>
		</xsl:call-template>
			],
			"",
			"",
			"<xsl:value-of select='@key'/>",
			gAuctionData,
			"<xsl:value-of select='@itemCount'/>" );

		aLot.contName =
		"<xsl:call-template name='escapeSpecialChars'>
			<xsl:with-param name='string' select='@contName'/>
		</xsl:call-template>";

		aLot.shipName = 
		"<xsl:call-template name='escapeSpecialChars'>
			<xsl:with-param name='string' select='@shipName'/>
		</xsl:call-template>";
     
		tempList.addItem( aLot );
	</xsl:for-each>
	tempList.EndTransaction(true);
    </xsl:for-each>

  gAuctionData.EndTransaction(true);
  </xsl:for-each>
  grvUNWAIT();
</xsl:template>


	<!-- =======================================================
			This XSL file contains the definitions that are
			common to all AJAX/EDO reply handling transforms
	     ======================================================= -->

<!-- generate a value (or "null" if not defined) -->
<xsl:template name="genVal">
    <xsl:param name="theVar"/>
    <xsl:choose>
	  <xsl:when test="$theVar">
		<xsl:value-of select="$theVar"/>
	  </xsl:when>
	  <xsl:otherwise>
		<xsl:text>null</xsl:text>
	  </xsl:otherwise>
	</xsl:choose>
</xsl:template>


<!-- generate a value (or "0" if not defined) -->
<xsl:template name="genZero">
    <xsl:param name="theVar"/>
    <xsl:choose>
	  <xsl:when test="$theVar">
		<xsl:value-of select="$theVar"/>
	  </xsl:when>
	  <xsl:otherwise>
		<xsl:text>0</xsl:text>
	  </xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- escape quote, newline, and backslash chars so Javascript is not confused -->
<xsl:template name="escapeSpecialChars">
<xsl:param name="string" />
    <xsl:choose>
      <!-- First need to escape embedded backslash characters, as
           these are the scheme escape character -->
      <xsl:when test="contains($string, '\')">
        <!-- recurse on the first part to process the " characters too -->
        <xsl:call-template name="escapeSpecialChars">
          <xsl:with-param name="string" select="substring-before($string,'\')"/>
        </xsl:call-template>
        <!-- output escaped backslash character -->
        <xsl:text>\\</xsl:text>
        <!-- recurse on the second part -->
        <xsl:call-template name="escapeSpecialChars">
          <xsl:with-param name="string" select="substring-after($string,'\')"/>
        </xsl:call-template>
      </xsl:when>

      <!-- If text contains the " character, escape it with a backslash.
           Note that if the text makes it this far into the choose, we
           know that it does not contain a \ character, and we need not
           recursively process it for one. -->
      <xsl:when test="contains($string, '&#x22;')">
        <!-- output the part up to the quote character -->
        <xsl:value-of select="substring-before($string, '&#x22;')" />
        <!-- output escaped quote character -->
        <xsl:text>\"</xsl:text>
        <xsl:call-template name="escapeSpecialChars">
          <xsl:with-param name="string" select="substring-after($string,'&#x22;')"/>
        </xsl:call-template>
      </xsl:when>

      <!-- If text contains the newline character, escape it with a backslash-n.
           Note that if the text makes it this far into the choose, we
           know that it does not contain a \ character, and we need not
           recursively process it for one. -->
      <xsl:when test="contains($string, '&#x0A;')">
        <!-- output the part up to the quote character -->
        <xsl:value-of select="substring-before($string, '&#x0A;')" />
        <!-- output escaped newline character -->
        <xsl:text>\n</xsl:text>
        <!--xsl:text disable-output-escaping="yes">&amp;diams;</xsl:text-->
        <xsl:call-template name="escapeSpecialChars">
          <xsl:with-param name="string" select="substring-after($string,'&#x0A;')"/>
        </xsl:call-template>
      </xsl:when>

      <xsl:otherwise>
        <xsl:value-of select="$string" />
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>