<xsl:stylesheet version = "1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- xsl:import href="../../Gravey/xsl/grvEDO.xsl"/ -->
<!-- =============================================================
     == Because of Safari/Chrome/IE7/8 bugs, xsl:import fails!
     == We will include the guts of this file directly as a hack.
     == See the bottom of this file...
     =============================================================
-->
<xsl:output method="text"/> 


<xsl:template match="/">
  gEDOServerError.setValue(
	"<xsl:call-template name='escapeSpecialChars'>
		<xsl:with-param name='string' select='/AIM/ServerError/String'/>
    </xsl:call-template>"
  );

  <xsl:for-each select="/AIM/Bidders/List/Bidder">
 {
  var tempList = null;
  var bidderKey = <xsl:value-of select='@key'/>;
 
	tempList = _ContactsSelected( bidderKey );
	tempList.loaded = true;
	tempList = tempList.model;
    tempList.BeginTransaction();
    tempList.reset();
	tempList.addItem( 0, new MVCDecode( "Contact", "0", "", 1 ) );
	<xsl:for-each select="Contacts/List/Contact">
		tempList.addItem( "<xsl:value-of select='@key'/>",
			new MVCDecode( "Contact",
			"<xsl:value-of select='@key'/>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@contactName'/>
			</xsl:call-template>",
			<xsl:call-template name='genVal'>
				<xsl:with-param name='theVar' select='@lotCount'/>
			</xsl:call-template>
		 ) );
	</xsl:for-each>
	tempList.EndTransaction();

	tempList = _ShippingSelected( bidderKey );
	tempList.loaded = true;
	tempList = tempList.model;
    tempList.BeginTransaction();
    tempList.reset();
	tempList.addItem( 0, new MVCDecode( "Shipping", "0", "", 1 ) );
	<xsl:for-each select="Shippings/List/Shipping">
		tempList.addItem( "<xsl:value-of select='@key'/>",
			new MVCDecode( "Shipping",
			"<xsl:value-of select='@key'/>",
			"<xsl:call-template name='escapeSpecialChars'>
				<xsl:with-param name='string' select='@companyName'/>
			</xsl:call-template>",
			<xsl:call-template name='genVal'>
				<xsl:with-param name='theVar' select='@lotCount'/>
			</xsl:call-template>
		 ) );
	</xsl:for-each>
	tempList.EndTransaction();
  }
  </xsl:for-each>

  _gGrvHackStartupInhibitWait = false;
//grvUNWAIT();
</xsl:template>


	<!-- =======================================================
			This XSL file contains the definitions that are
			common to all AJAX/EDO reply handling transforms
	     ======================================================= -->

<!-- generate a value (or "null" if not defined) -->
<xsl:template name="genVal">
    <xsl:param name="theVar"/>
    <xsl:choose>
	  <xsl:when test="$theVar">
		<xsl:value-of select="$theVar"/>
	  </xsl:when>
	  <xsl:otherwise>
		<xsl:text>null</xsl:text>
	  </xsl:otherwise>
	</xsl:choose>
</xsl:template>


<!-- generate a value (or "0" if not defined) -->
<xsl:template name="genZero">
    <xsl:param name="theVar"/>
    <xsl:choose>
	  <xsl:when test="$theVar">
		<xsl:value-of select="$theVar"/>
	  </xsl:when>
	  <xsl:otherwise>
		<xsl:text>0</xsl:text>
	  </xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- escape quote, newline, and backslash chars so Javascript is not confused -->
<xsl:template name="escapeSpecialChars">
<xsl:param name="string" />
    <xsl:choose>
      <!-- First need to escape embedded backslash characters, as
           these are the scheme escape character -->
      <xsl:when test="contains($string, '\')">
        <!-- recurse on the first part to process the " characters too -->
        <xsl:call-template name="escapeSpecialChars">
          <xsl:with-param name="string" select="substring-before($string,'\')"/>
        </xsl:call-template>
        <!-- output escaped backslash character -->
        <xsl:text>\\</xsl:text>
        <!-- recurse on the second part -->
        <xsl:call-template name="escapeSpecialChars">
          <xsl:with-param name="string" select="substring-after($string,'\')"/>
        </xsl:call-template>
      </xsl:when>

      <!-- If text contains the " character, escape it with a backslash.
           Note that if the text makes it this far into the choose, we
           know that it does not contain a \ character, and we need not
           recursively process it for one. -->
      <xsl:when test="contains($string, '&#x22;')">
        <!-- output the part up to the quote character -->
        <xsl:value-of select="substring-before($string, '&#x22;')" />
        <!-- output escaped quote character -->
        <xsl:text>\"</xsl:text>
        <xsl:call-template name="escapeSpecialChars">
          <xsl:with-param name="string" select="substring-after($string,'&#x22;')"/>
        </xsl:call-template>
      </xsl:when>

      <!-- If text contains the newline character, escape it with a backslash-n.
           Note that if the text makes it this far into the choose, we
           know that it does not contain a \ character, and we need not
           recursively process it for one. -->
      <xsl:when test="contains($string, '&#x0A;')">
        <!-- output the part up to the quote character -->
        <xsl:value-of select="substring-before($string, '&#x0A;')" />
        <!-- output escaped newline character -->
        <xsl:text>\n</xsl:text>
        <!--xsl:text disable-output-escaping="yes">&amp;diams;</xsl:text-->
        <xsl:call-template name="escapeSpecialChars">
          <xsl:with-param name="string" select="substring-after($string,'&#x0A;')"/>
        </xsl:call-template>
      </xsl:when>

      <xsl:otherwise>
        <xsl:value-of select="$string" />
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>